<?php
include_once 'inc/navigation.php';
?>

   <main>

      <!-- breadcrumb-area-start -->
      <div class="it-breadcrumb-area it-breadcrumb-bg" data-background="images/students_in_class_joy_studio_academy.webp">
         <div class="container">
            <div class="row ">
               <div class="col-md-12">
                  <div class="it-breadcrumb-content z-index-3 text-center">
                     <div class="it-breadcrumb-title-box">
                        <h3 class="it-breadcrumb-title">contact us</h3>
                     </div>
                     <div class="it-breadcrumb-list-wrap">
                        <div class="it-breadcrumb-list">
                           <span><a href="/">home</a></span>
                           <span class="dvdr">//</span>
                           <span>contact</span>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- breadcrumb-area-end -->

      <!-- contact-area-start -->
      <div class="it-contact__area pt-120 pb-120">
         <div class="container">
            <div class="it-contact__wrap fix z-index-3 p-relative">
               <div class="it-contact__shape-1 d-none d-xl-block">
                  <img src="assets/img/contact/shape-2-1.png" alt="">
               </div>
               <div class="row align-items-end">
                  <div class="col-xl-7">
                     <div class="it-contact__right-box">
                        <div class="it-contact__section-box pb-20">
                            <h4 class="it-contact__title pb-15">Get in Touch</h4>
                            <p>
                                Have questions or want to enroll your child? <br>
                                Our team at Joy Sounds Academy is ready to assist you and provide all the information you need.
                            </p>
                        </div>

                        <div class="it-contact__content mb-55">
                           <ul>
                              <li>
                                 <div class="it-contact__list d-flex align-items-start">
                                    <div class="it-contact__icon">
                                       <span><i class="fa-solid fa-location-dot"></i></span>
                                    </div>
                                    <div class="it-contact__text">
                                       <span>Our Address</span>
                                       <a href="#"><?= $site_address ?></a> 
                                    </div>
                                 </div>
                              </li>
                              <li>
                                 <div class="it-contact__list d-flex align-items-start">
                                    <div class="it-contact__icon">
                                       <span><i class="fa-solid fa-clock"></i></span>
                                    </div>
                                    <div class="it-contact__text">
                                       <span>Hours of Operation</span>
                                       <a href="#">Mon - Fri: 8.00am to 4.00pm</a>
                                       <span></span>
                                    </div>
                                 </div>
                              </li>
                              <li>
                                 <div class="it-contact__list d-flex align-items-start">
                                    <div class="it-contact__icon">
                                       <span><i class="fa-solid fa-phone phone"></i></span>
                                    </div>
                                    <div class="it-contact__text">
                                       <span>contact</span>
                                       <a href="tel:<?= $site_hotline ?>"><?= $site_hotline ?></a>
                                       <a href="mailto:<?= $site_email ?>"><?= $site_email ?></a>
                                    </div>
                                 </div>
                              </li>
                           </ul>
                        </div>
                        <div class="it-contact__bottom-box d-flex align-items-center justify-content-between">
                           <div class="it-contact__scrool smooth">
                              <a href="#it-newsletter"><i class="fa-solid fa-arrow-down"></i>Customer Care</a>
                           </div>
                           <div class="it-footer-social">
                              <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
                              <a href="#"><i class="fa-brands fa-instagram"></i></a>
                              <a href="#"><i class="fa-brands fa-pinterest-p"></i></a>
                              <a href="#"><i class="fa-brands fa-twitter"></i></a>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="col-xl-5">
                     <div class="it-contact__form-box">
                        <form id="contact-form" method="POST">
                            <div class="row">
                                <div class="col-12 mb-25">
                                    <div class="it-contact-input-box">
                                        <label for="contact-name">Name*</label>
                                        <input type="text" id="contact-name" name="name" placeholder="Name" required>
                                    </div>
                                </div>
                                <div class="col-12 mb-25">
                                    <div class="it-contact-input-box">
                                        <label for="contact-email">Email Address*</label>
                                        <input type="email" id="contact-email" name="email" placeholder="Email" required>
                                    </div>
                                </div>
                                <div class="col-12 mb-25">
                                    <div class="it-contact-input-box">
                                        <label for="contact-phone">Phone*</label>
                                        <input type="text" id="contact-phone" name="phone" placeholder="Phone" required>
                                    </div>
                                </div>
                                <div class="col-12 mb-25">
                                    <div class="it-contact-input-box">
                                        <label for="contact-subject">Subject*</label>
                                        <input type="text" id="contact-subject" name="subject" placeholder="Subject" required>
                                    </div>
                                </div>
                                <div class="col-12 mb-25">
                                    <div class="it-contact-textarea-box">
                                        <label for="contact-message">Message*</label>
                                        <textarea id="contact-message" name="message" placeholder="Message" required></textarea>
                                    </div>
                                </div>
                            </div>
                            
                            <div id="contact-message-box" style="margin-bottom: 20px;"></div>
                            
                            <button type="submit" class="it-btn" id="contact-submit-btn">
                                <span id="btn-text">
                                    Send Message
                                    <svg width="17" height="14" viewBox="0 0 17 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M11 1.24023L16 7.24023L11 13.2402" stroke="currentcolor" stroke-width="1.5"
                                            stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                        <path d="M1 7.24023H16" stroke="currentcolor" stroke-width="1.5" stroke-miterlimit="10"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                </span>
                                <span id="btn-spinner" style="display: none;">
                                    <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="animation: spin 1s linear infinite;">
                                        <path d="M12 2V6" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                        <path d="M12 18V22" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                        <path d="M4.93 4.93L7.76 7.76" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                        <path d="M16.24 16.24L19.07 19.07" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                        <path d="M2 12H6" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                        <path d="M18 12H22" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                        <path d="M4.93 19.07L7.76 16.24" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                        <path d="M16.24 7.76L19.07 4.93" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                    </svg>
                                </span>
                            </button>
                        </form>
                    </div>

                    <style>
                    @keyframes spin {
                        0% { transform: rotate(0deg); }
                        100% { transform: rotate(360deg); }
                    }

                    #contact-message-box {
                        min-height: 50px;
                        padding: 12px 15px;
                        border-radius: 4px;
                        font-size: 14px;
                        transition: all 0.3s ease;
                    }

                    .message-success {
                        background-color: rgba(76, 175, 80, 0.1);
                        color: #2e7d32;
                        border-left: 4px solid #2e7d32;
                    }

                    .message-error {
                        background-color: rgba(244, 67, 54, 0.1);
                        color: #d32f2f;
                        border-left: 4px solid #d32f2f;
                    }

                    #contact-submit-btn {
                        position: relative;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        gap: 10px;
                        transition: all 0.3s ease;
                    }

                    #contact-submit-btn:disabled {
                        opacity: 0.7;
                        cursor: not-allowed;
                    }

                    /* Input styling */
                    .it-contact-input-box input,
                    .it-contact-textarea-box textarea {
                        width: 100%;
                        padding: 12px 15px;
                        border: 1px solid #ddd;
                        border-radius: 4px;
                        font-size: 14px;
                        transition: border-color 0.3s ease;
                    }

                    .it-contact-input-box input:focus,
                    .it-contact-textarea-box textarea:focus {
                        outline: none;
                        border-color: #7A1E2B;
                        box-shadow: 0 0 0 2px rgba(122, 30, 43, 0.1);
                    }

                    .it-contact-textarea-box textarea {
                        min-height: 120px;
                        resize: vertical;
                    }

                    label {
                        display: block;
                        margin-bottom: 8px;
                        font-weight: 500;
                        color: #333;
                    }
                    </style>


                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- contact-area-end -->

      <!-- newsletter-area-start 
      <div id="it-newsletter" class="it-newsletter-area it-newsletter-height fix p-relative theme-bg">
         <div class="it-newsletter-shape-1 d-none d-lg-block">
            <img src="assets/img/newsletter/shape-1-1.png" alt="">
         </div>
         <div class="it-newsletter-shape-2 d-none d-lg-block">
            <img src="assets/img/newsletter/shape-1-2.png" alt="">
         </div>
         <div class="it-newsletter-shape-3 d-none d-xl-block">
            <img src="assets/img/newsletter/shape-1-3.png" alt="">
         </div>
         <div class="it-newsletter-shape-4 d-none d-xl-block">
            <img src="assets/img/newsletter/shape-1-4.png" alt="">
         </div>
         <div class="container">
            <div class="row">
               <div class="col-xl-6 col-lg-6 col-md-6">
                  <div class="it-newsletter-left">
                     <h4 class="it-section-title text-white pb-20">Join Our Newsletter</h4>
                     <span>Subscribe our newsletter to get our latest update & news.</span>
                  </div>
               </div>
               <div class="col-xl-6 col-lg-6 col-md-6">
                  <div class="it-newsletter-right p-relative text-end">
                     <input type="text" placeholder="Enter your email:">
                     <button class="it-btn black-bg" type="submit"><span>subscribe now</span></button>
                  </div>
               </div>
            </div>
         </div>
      </div>-->
      <!-- newsletter-area-end -->

   </main>
<?php
include_once 'inc/footer.php';
?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('contact-form');
    const submitBtn = document.getElementById('contact-submit-btn');
    const btnText = document.getElementById('btn-text');
    const btnSpinner = document.getElementById('btn-spinner');
    const messageBox = document.getElementById('contact-message-box');
    
    form.addEventListener('submit', async function(e) {
        e.preventDefault();
        
        // Validate form
        if (!validateForm()) {
            return;
        }
        
        // Show loading state
        setLoadingState(true);
        clearMessage();
        
        try {
            const formData = new FormData(form);
            
            const response = await fetch('actions/contact-submit.php', {
                method: 'POST',
                body: formData
            });
            
            const result = await response.json();
            
            if (result.success) {
                showMessage(result.message, 'success');
                form.reset();
                
                // Optional: Show reference number
                setTimeout(() => {
                    if (result.message_id) {
                        showMessage(`${result.message}<br><small>Reference: #${result.message_id}</small>`, 'success');
                    }
                }, 1000);
            } else {
                showMessage(result.message, 'error');
            }
            
        } catch (error) {
            console.error('Contact form error:', error);
            showMessage('An error occurred. Please try again.', 'error');
        } finally {
            setLoadingState(false);
        }
    });
    
    function validateForm() {
        const inputs = form.querySelectorAll('input[required], textarea[required]');
        let isValid = true;
        
        inputs.forEach(input => {
            input.style.borderColor = '#ddd';
            
            if (!input.value.trim()) {
                input.style.borderColor = '#d32f2f';
                isValid = false;
                
                if (!messageBox.innerHTML.includes('Please fill in all required fields')) {
                    showMessage('Please fill in all required fields', 'error');
                }
            }
            
            // Email validation
            if (input.type === 'email' && input.value.trim()) {
                if (!isValidEmail(input.value)) {
                    input.style.borderColor = '#d32f2f';
                    showMessage('Please enter a valid email address', 'error');
                    isValid = false;
                }
            }
        });
        
        return isValid;
    }
    
    function setLoadingState(isLoading) {
        if (isLoading) {
            submitBtn.disabled = true;
            btnText.style.opacity = '0.7';
            btnSpinner.style.display = 'inline-block';
        } else {
            submitBtn.disabled = false;
            btnText.style.opacity = '1';
            btnSpinner.style.display = 'none';
        }
    }
    
    function showMessage(message, type) {
        messageBox.innerHTML = message;
        messageBox.className = '';
        messageBox.classList.add(`message-${type}`);
        
        // Auto-hide message after 8 seconds for success, 10 for error
        const hideTime = type === 'success' ? 8000 : 10000;
        setTimeout(() => {
            if (messageBox.innerHTML === message) {
                clearMessage();
            }
        }, hideTime);
    }
    
    function clearMessage() {
        messageBox.innerHTML = '';
        messageBox.className = '';
    }
    
    function isValidEmail(email) {
        const re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(String(email).toLowerCase());
    }
    
    // Clear validation styles when user types
    form.querySelectorAll('input, textarea').forEach(input => {
        input.addEventListener('input', function() {
            this.style.borderColor = '#ddd';
            if (messageBox.innerHTML && !messageBox.innerHTML.includes('success')) {
                clearMessage();
            }
        });
    });
});
</script>