<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

session_start();

$db_host = '127.0.0.1';
$db_name = 'universal';
$db_user = 'root';
$db_pass = '';

include_once __DIR__ . '/config.php';

// 3️⃣ Connect using PDO
try {
    $dsn = "mysql:host={$db_host};dbname={$db_name};charset=utf8mb4";
    $pdo = new PDO($dsn, $db_user, $db_pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => 'DB connection error: ' . $e->getMessage()]);
    exit;
}
