
   <footer>
      <!-- footer-area-start -->
      <div class="it-footer-area it-footer-bg it-footer-style-5 black-bg pb-70"
         data-background="assets/img/footer/bg-1-1.jpg">
         <div class="it-footer-border">
            <div class="container">
               <div class="row">
                  <div class="col-xl-4 col-lg-4 col-md-4">
                     <div class="it-footer-top-info d-flex align-items-center it-footer-top-col-1">
                        <div class="it-footer-top-icon">
                           <span><i class="fa-light fa-location-dot"></i></span>
                        </div>
                        <div class="it-footer-top-text">
                           <span class="text-white">Address:</span>
                           <a href="#"><?= $site_address ?></a>
                        </div>
                     </div>
                  </div>
                  <div class="col-xl-4 col-lg-4 col-md-4">
                     <div class="it-footer-top-info d-flex align-items-center it-footer-top-col-2">
                        <div class="it-footer-top-icon">
                           <span><i class="fa-light fa-phone phone"></i></span>
                        </div>
                        <div class="it-footer-top-text">
                           <span class="text-white">Phone:</span>
                           <a href="tel:<?= $site_hotline ?>"><?= $site_hotline ?></a>
                        </div>
                     </div>
                  </div>
                  <div class="col-xl-4 col-lg-4 col-md-4">
                     <div
                        class="it-footer-top-info d-flex align-items-center justify-content-md-end border-none it-footer-top-col-3">
                        <div class="it-footer-top-icon">
                           <span><i class="fa-light fa-envelope"></i></span>
                        </div>
                        <div class="it-footer-top-text">
                           <span class="text-white">Email:</span>
                           <a href="mailto:<?= $site_email ?>"><?= $site_email ?></a>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <div class="it-footer-wrap pt-120">
            <div class="container">
               <div class="row">
                  <div class="col-xl-4 col-lg-4 col-md-6 col-sm-6 mb-50">
                     <div class="it-footer-widget footer-col-5">
                        <div class="it-footer-logo pb-25">
                           <a href="index.php">
                              <img src="images/joysoundsacademy_logo.webp" alt="<?= $site_name ?>" loading="lazy" style="width:150px;height:auto;object-fit:cover;">
                           </a>
                        </div>
                        <div class="it-footer-text pb-5">
                           <p>
                              Joy Sounds Academy & Junior School is a child-centered learning community in Makueni,
                              committed to nurturing confident learners through quality education and holistic development.
                           </p>
                        </div>

                        <div class="it-footer-social">
                           <a href="#"><i class="fa-brands fa-facebook-f"></i></a>
                           <a href="#"><i class="fa-brands fa-instagram"></i></a>
                           <a href="#"><i class="fa-brands fa-pinterest-p"></i></a>
                           <a href="#"><i class="fa-brands fa-twitter"></i></a>
                        </div>
                     </div>
                  </div>
                  <div class="col-xl-2 col-lg-3 col-md-6 col-sm-6 mb-50">
                     <div class="it-footer-widget footer-col-6">
                        <h4 class="it-footer-title">Quick Links</h4>
                        <div class="it-footer-list">
                           <ul>
                                 <li>
                                    <a href="about.php">
                                       <i class="fa-regular fa-angle-right"></i>
                                       About Joy Sounds Academy
                                    </a>
                                 </li>
                                 <li>
                                    <a href="#academics.php">
                                       <i class="fa-regular fa-angle-right"></i>
                                       Academics & Curriculum
                                    </a>
                                 </li>
                                 <li>
                                    <a href="blog.php">
                                       <i class="fa-regular fa-angle-right"></i>
                                       News & School Updates
                                    </a>
                                 </li>
                                 <li>
                                    <a href="blog.php">
                                       <i class="fa-regular fa-angle-right"></i>
                                       Events & Activities
                                    </a>
                                 </li>
                                 <li>
                                    <a href="contact.php">
                                       <i class="fa-regular fa-angle-right"></i>
                                       Contact Us
                                    </a>
                                 </li>
                           </ul>
                        </div>
                     </div>

                  </div>
                  <div class="col-xl-3 col-lg-4 col-md-6 col-sm-6 mb-50">
                     <div class="it-footer-widget footer-col-4">
                        <h4 class="it-footer-title">Gallery</h4>
                        <div class="it-footer-gallery-box">
                           <?php
                           try {
                              // Fetch 6 portfolio items
                              $sql = "SELECT * FROM portfolio WHERE publish_status = 1 ORDER BY created_at DESC LIMIT 6";
                              $stmt = $pdo->prepare($sql);
                              $stmt->execute();
                              $portfolioItems = $stmt->fetchAll(PDO::FETCH_ASSOC);
                           } catch(PDOException $e) {
                              die("Database error: " . $e->getMessage());
                           }
                           ?>

                           <div class="row gx-5">
                              <?php
                              if (!empty($portfolioItems)) {
                                 foreach($portfolioItems as $item) {
                                       // Get first image from comma-separated list
                                       $images = !empty($item['images']) ? explode(',', $item['images']) : [];
                                       $firstImage = !empty($images[0]) ? trim($images[0]) : 'assets/img/footer/thumb-1-1.png';
                                       $altText = !empty($item['title']) ? htmlspecialchars($item['title']) : 'Portfolio Image';
                                       ?>
                                       
                                       <div class="col-md-4 col-4">
                                          <div class="it-footer-thumb mb-10">
                                             <img src="portfolio_images/<?php echo htmlspecialchars($firstImage); ?>" alt="<?php echo $altText; ?>" loading="lazy" style="width: 100%; height: 100px; object-fit: cover;">
                                          </div>
                                       </div>
                                       
                                       <?php
                                 }
                              } else {
                                 // Show fallback images if no portfolio items
                                 for ($i = 1; $i <= 6; $i++) {
                                       ?>
                                       <div class="col-md-4 col-4">
                                          <div class="it-footer-thumb mb-10">
                                             <img src="assets/img/footer/thumb-1-<?php echo $i; ?>.png" alt="Gallery Image <?php echo $i; ?>" loading="lazy" style="width: 100%; height: auto; object-fit: cover;">
                                          </div>
                                       </div>
                                       <?php
                                 }
                              }
                              ?>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="col-xl-3 col-lg-3 col-md-6 col-sm-8 mb-50">
                     <div class="it-footer-widget footer-col-8">
                        <h4 class="it-footer-title">Subscribe</h4>
                        <div class="it-footer-input-box p-relative">
                           <form id="newsletter-form" method="POST">
                                 <input 
                                    class="mb-20" 
                                    type="email" 
                                    name="email" 
                                    id="newsletter-email"
                                    placeholder="Enter your email:" 
                                    required
                                    style="padding-right: 50px;"
                                 >
                                 <button type="submit" class="it-btn-white sky-bg" id="subscribe-btn">
                                    <span id="btn-text">SUBSCRIBE NOW</span>
                                    <span id="btn-spinner" style="display: none;">
                                       <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="animation: spin 1s linear infinite;">
                                             <path d="M12 2V6" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                             <path d="M12 18V22" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                             <path d="M4.93 4.93L7.76 7.76" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                             <path d="M16.24 16.24L19.07 19.07" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                             <path d="M2 12H6" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                             <path d="M18 12H22" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                             <path d="M4.93 19.07L7.76 16.24" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                             <path d="M16.24 7.76L19.07 4.93" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                       </svg>
                                    </span>
                                 </button>
                           </form>
                        </div>
                        <div id="newsletter-message" style="margin-top: 10px;"></div>
                     </div>

                     <style>
                     @keyframes spin {
                        0% { transform: rotate(0deg); }
                        100% { transform: rotate(360deg); }
                     }

                     #newsletter-message {
                        min-height: 40px;
                        padding: 8px 12px;
                        border-radius: 4px;
                        font-size: 14px;
                        transition: all 0.3s ease;
                     }

                     .message-success {
                        background-color: rgba(76, 175, 80, 0.1);
                        color: #2e7d32;
                        border-left: 4px solid #2e7d32;
                     }

                     .message-error {
                        background-color: rgba(244, 67, 54, 0.1);
                        color: #d32f2f;
                        border-left: 4px solid #d32f2f;
                     }

                     #subscribe-btn:disabled {
                        opacity: 0.7;
                        cursor: not-allowed;
                     }

                     .it-footer-input-box {
                        position: relative;
                     }

                     .it-footer-input-box input {
                        width: 100%;
                        padding: 12px 120px 12px 20px;
                        border: 1px solid #ddd;
                        border-radius: 4px;
                        font-size: 14px;
                     }

                     .it-footer-input-box input:focus {
                        outline: none;
                        border-color: #7A1E2B;
                        box-shadow: 0 0 0 2px rgba(122, 30, 43, 0.2);
                     }
                     </style>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <!-- footer-area-end -->

      <!-- copy-right area start -->
      <div class="it-copyright-area it-copyright-height">
         <div class="container">
            <div class="row">
               <div class="col-12 wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".3s">
                  <div class="it-copyright-text text-center">
                     <p>
                           © <?= date('Y'); ?> Joy Sounds Academy & Junior School. All Rights Reserved. <br class="d-none d-md-block">
                           Developed by <a href="https://veen.africa" target="_blank" rel="noopener noreferrer">Veen Africa</a>
                     </p>
                  </div>
               </div>

            </div>
         </div>
      </div>
      <!-- copy-right area end -->

   </footer>



   <!-- JS here -->
   <script src="assets/js/jquery.js"></script>
   <script src="assets/js/waypoints.js"></script>
   <script src="assets/js/bootstrap.bundle.min.js"></script>
   <script src="assets/js/slick.min.js"></script>
   <script src="assets/js/magnific-popup.js"></script>
   <script src="assets/js/purecounter.js"></script>
   <script src="assets/js/wow.js"></script>
   <script src="assets/js/countdown.js"></script>
   <script src="assets/js/nice-select.js"></script>
   <script src="assets/js/swiper-bundle.js"></script>
   <script src="assets/js/isotope-pkgd.js"></script>
   <script src="assets/js/imagesloaded-pkgd.js"></script>
   <script src="assets/js/ajax-form.js"></script>
   <script src="assets/js/main.js"></script>



</body>


</html>

<script>
// Variables for load more functionality
let currentPage = 1;
let totalItems = <?php echo $totalCount; ?>;
let itemsPerPage = 2;
let isLoading = false;
let loadedItems = document.querySelectorAll('.portfolio-item').length;

// Initialize lazy loading
function initLazyLoading() {
    const lazyImages = document.querySelectorAll('img.lazy');
    
    if ('IntersectionObserver' in window) {
        const imageObserver = new IntersectionObserver((entries, observer) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    const img = entry.target;
                    img.src = img.dataset.src;
                    img.classList.add('loaded');
                    imageObserver.unobserve(img);
                }
            });
        }, {
            rootMargin: '50px 0px',
            threshold: 0.1
        });
        
        lazyImages.forEach(img => imageObserver.observe(img));
    } else {
        // Fallback for older browsers
        lazyImages.forEach(img => {
            img.src = img.dataset.src;
            img.classList.add('loaded');
        });
    }
}

// Load more items
async function loadMoreItems() {
    if (isLoading) return;
    
    const loadMoreBtn = document.getElementById('load-more-btn');
    const loader = loadMoreBtn.querySelector('.loader');
    const btnText = loadMoreBtn.querySelector('span');
    
    // Show loading state
    isLoading = true;
    btnText.textContent = 'Loading...';
    loader.style.display = 'block';
    loadMoreBtn.disabled = true;
    
    try {
        currentPage++;
        const response = await fetch(`actions/load-portfolio.php?page=${currentPage}&per_page=${itemsPerPage}`);
        const data = await response.json();
        
        if (data.success && data.items.length > 0) {
            // Add new items to grid
            const grid = document.getElementById('portfolio-grid');
            
            data.items.forEach(item => {
                const images = item.images ? item.images.split(',') : [];
                const firstImage = images.length > 0 ? images[0].trim() : 'assets/img/placeholder.jpg';
                const description = item.description ? 
                    item.description.substring(0, 120) + '...' : 
                    'No description available.';
                
                const categorySlug = item.title.toLowerCase().replace(/[^a-zA-Z0-9]+/g, '-');
                
                const itemHTML = `
                    <div class="col-xl-4 col-lg-4 col-md-6 mb-4 portfolio-item" data-category="${categorySlug}" data-id="${item.id}">
                        <div class="portfolio-card" style="border: 1px solid #f0f0f0; border-radius: 8px; overflow: hidden; transition: all 0.3s ease; height: 100%;">
                            <div class="portfolio-media" style="position: relative; overflow: hidden; height: 280px;">
                                ${item.video_link ? `
                                    <div class="video-thumbnail" style="position: relative; height: 100%;" data-video="${item.video_link}">
                                        <img src="assets/img/placeholder.jpg" data-src="${firstImage}" alt="${item.title}" class="lazy" style="width: 100%; height: 100%; object-fit: cover; background: #f5f5f5;">
                                        <div class="video-overlay" style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; background: rgba(122, 30, 43, 0.7); display: flex; align-items: center; justify-content: center; opacity: 0; transition: opacity 0.3s ease;">
                                            <div class="play-button" style="width: 60px; height: 60px; background: white; border-radius: 50%; display: flex; align-items: center; justify-content: center; cursor: pointer;">
                                                <svg width="24" height="24" viewBox="0 0 24 24" fill="#7A1E2B">
                                                    <path d="M8 5v14l11-7z"/>
                                                </svg>
                                            </div>
                                        </div>
                                    </div>
                                ` : `
                                    <div class="image-gallery" style="position: relative; height: 100%;">
                                        <img src="assets/img/placeholder.jpg" data-src="${firstImage}" alt="${item.title}" class="lazy" style="width: 100%; height: 100%; object-fit: cover; background: #f5f5f5;">
                                        ${images.length > 1 ? `
                                            <div class="gallery-indicator" style="position: absolute; top: 15px; right: 15px; background: white; color: #7A1E2B; width: 36px; height: 36px; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-weight: 600; font-size: 14px; box-shadow: 0 2px 10px rgba(0,0,0,0.1);">
                                                +${images.length - 1}
                                            </div>
                                        ` : ''}
                                    </div>
                                `}
                            </div>
                            <div class="portfolio-content" style="padding: 25px; background: white;">
                                <h5 class="portfolio-item-title" style="color: #000000; font-size: 20px; font-weight: 600; margin: 0 0 15px 0; line-height: 1.3;">
                                    ${item.title}
                                </h5>
                                <p class="portfolio-description" style="color: #666666; font-size: 15px; line-height: 1.6; margin: 0 0 20px 0;">
                                    ${description}
                                </p>
                                <div class="portfolio-meta" style="display: flex; justify-content: space-between; align-items: center; border-top: 1px solid #f0f0f0; padding-top: 15px;">
                                    <span class="portfolio-date" style="color: #7A1E2B; font-size: 14px; font-weight: 500;">
                                        <svg width="16" height="16" viewBox="0 0 24 24" fill="#7A1E2B" style="margin-right: 5px; vertical-align: middle;">
                                            <path d="M19 4h-1V2h-2v2H8V2H6v2H5c-1.11 0-1.99.9-1.99 2L3 20a2 2 0 002 2h14c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 16H5V10h14v10zM5 6v2h14V6H5zm2 4h10v2H7zm0 4h7v2H7z"/>
                                        </svg>
                                        ${new Date(item.created_at).toLocaleDateString('en-US', { month: 'short', day: 'numeric', year: 'numeric' })}
                                    </span>
                                    <a href="portfolio-details.php?slug=${item.slug}" class="view-more-btn" style="color: #7A1E2B; text-decoration: none; font-weight: 600; font-size: 14px; display: inline-flex; align-items: center; transition: all 0.3s ease;">
                                        View Details
                                        <svg width="16" height="12" viewBox="0 0 17 14" fill="none" style="margin-left: 8px; transition: transform 0.3s ease;">
                                            <path d="M11 1.24023L16 7.24023L11 13.2402" stroke="#7A1E2B" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                            <path d="M1 7.24023H16" stroke="#7A1E2B" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                `;
                
                grid.insertAdjacentHTML('beforeend', itemHTML);
            });
            
            // Update loaded items count
            loadedItems += data.items.length;
            
            // Initialize lazy loading for new images
            initLazyLoading();
            
            // Hide load more button if all items loaded
            if (loadedItems >= totalItems) {
                loadMoreBtn.style.display = 'none';
                document.getElementById('no-more-items').style.display = 'block';
            }
        }
    } catch (error) {
        console.error('Error loading more items:', error);
    } finally {
        // Reset button state
        isLoading = false;
        btnText.textContent = 'Load More';
        loader.style.display = 'none';
        loadMoreBtn.disabled = false;
    }
}

// Event listeners
document.addEventListener('DOMContentLoaded', function() {
    // Initialize lazy loading
    initLazyLoading();
    
    // Load more button click
    const loadMoreBtn = document.getElementById('load-more-btn');
    if (loadMoreBtn) {
        loadMoreBtn.addEventListener('click', loadMoreItems);
    }
    
    // Filter functionality
    const filterSelect = document.querySelector('.filter-select');
    if (filterSelect) {
        filterSelect.addEventListener('change', function(e) {
            const selectedCategory = e.target.value;
            const items = document.querySelectorAll('.portfolio-item');
            
            items.forEach(item => {
                if (selectedCategory === 'all' || 
                    item.dataset.category.includes(selectedCategory) || 
                    item.querySelector('.portfolio-item-title')?.textContent.toLowerCase().includes(selectedCategory)) {
                    item.style.display = 'block';
                } else {
                    item.style.display = 'none';
                }
            });
        });
    }
    
    // Video play functionality
    document.addEventListener('click', function(e) {
        if (e.target.closest('.play-button')) {
            e.stopPropagation();
            const videoThumbnail = e.target.closest('.video-thumbnail');
            if(videoThumbnail) {
                const videoLink = videoThumbnail.dataset.video;
                if(videoLink) {
                    window.open(videoLink, '_blank');
                }
            }
        }
        
        // Image gallery click to view details
        if (e.target.closest('.image-gallery')) {
            const portfolioItem = e.target.closest('.portfolio-item');
            const viewMoreLink = portfolioItem.querySelector('.view-more-btn');
            if(viewMoreLink) {
                window.location.href = viewMoreLink.href;
            }
        }
    });
});
</script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const form = document.getElementById('newsletter-form');
    const emailInput = document.getElementById('newsletter-email');
    const submitBtn = document.getElementById('subscribe-btn');
    const btnText = document.getElementById('btn-text');
    const btnSpinner = document.getElementById('btn-spinner');
    const messageDiv = document.getElementById('newsletter-message');
    
    form.addEventListener('submit', async function(e) {
        e.preventDefault();
        
        const email = emailInput.value.trim();
        
        // Validate email
        if (!email || !isValidEmail(email)) {
            showMessage('Please enter a valid email address', 'error');
            emailInput.focus();
            return;
        }
        
        // Show loading state
        setLoadingState(true);
        
        try {
            const formData = new FormData();
            formData.append('email', email);
            
            const response = await fetch('actions/newsletter-submit.php', {
                method: 'POST',
                body: formData
            });
            
            const result = await response.json();
            
            if (result.success) {
                showMessage(result.message, 'success');
                form.reset();
                
                // Show discount code if available
                if (result.discount_code) {
                    setTimeout(() => {
                        showMessage(`Your discount code: <strong>${result.discount_code}</strong> - Use it on your next purchase!`, 'success');
                    }, 2000);
                }
            } else {
                showMessage(result.message, 'error');
            }
            
        } catch (error) {
            console.error('Subscription error:', error);
            showMessage('An error occurred. Please try again.', 'error');
        } finally {
            setLoadingState(false);
        }
    });
    
    function setLoadingState(isLoading) {
        if (isLoading) {
            submitBtn.disabled = true;
            btnText.style.opacity = '0.7';
            btnSpinner.style.display = 'inline-block';
        } else {
            submitBtn.disabled = false;
            btnText.style.opacity = '1';
            btnSpinner.style.display = 'none';
        }
    }
    
    function showMessage(message, type) {
        messageDiv.innerHTML = message;
        messageDiv.className = '';
        messageDiv.classList.add(`message-${type}`);
        
        // Auto-hide message after 5 seconds for success, 8 for error
        const hideTime = type === 'success' ? 5000 : 8000;
        setTimeout(() => {
            if (messageDiv.innerHTML === message) {
                messageDiv.innerHTML = '';
                messageDiv.className = '';
            }
        }, hideTime);
    }
    
    function isValidEmail(email) {
        const re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
        return re.test(String(email).toLowerCase());
    }
    
    // Clear message when user starts typing
    emailInput.addEventListener('input', function() {
        if (messageDiv.innerHTML) {
            messageDiv.innerHTML = '';
            messageDiv.className = '';
        }
    });
});
</script>
